require( "scripts/style.lua" )

HeaderFont = {
  standardFont,
  28,
  BlackColor
};

TableInfoFont = {
  standardFont,
  24,
 BlackColor
};

ErrorFont = {
  standardFont,
  24,
 BlackColor
};

AccountFont2 = {
  standardFont,
  16,
  BlackColor
};

AccountFont = {
  standardFont,
  20,
  BlackColor
};

ScoreFont = {
  standardFont,
  16,
  BlackColor
};

HiscoreSubmitLegal = {
  standardFont,
  16,
  BlackColor
};


vHSButtonGraphics=
{
	"buttons/btn_a_normal.png",
	"buttons/btn_a_down.png",
	"buttons/btn_a_over.png",
}

vHSButtonFontStyle = { standardFont, 16, BlackColor };


kPlayerNameY = 80;
kScoreY = 110;
kYourPFAccountY = 150;
kAccountNameY = 170;
kPasswordY = 200;
kRememberY = 230;

kPrivacyLabel = 'privacy';
if (IsEnabled(kHiscoreAnonymous)) then
	kPrivacyLabel = 'privacy_info';
end




function SwitchModes( submit )
	
	local localHS = IsEnabled(kHiscoreLocalOnly);
	local anonHS = IsEnabled(kHiscoreAnonymous);
	local fullHS = (not localHS) and (not anonHS);

	if submit then
		DebugOut( "SwitchModes true "..tostring(localHS).." "..tostring(anonHS));
	else
		DebugOut( "SwitchModes false "..tostring(localHS).." "..tostring(anonHS));
	end
	

	EnableWindow("header",not submit);
	EnableWindow("headershadow",not submit);
	EnableWindow("playertext", not submit and gMedalsMode == false);
	EnableWindow("yourscore", not submit and gMedalsMode == false);
	EnableWindow("eligiblescore", not submit and gMedalsMode == false);
	EnableWindow("yourpfaccount", not submit and fullHS);
	EnableWindow("nametext", not submit and fullHS);
	EnableWindow("passtext", not submit and fullHS);

	EnableWindow("nameeditbox", not submit  and gMedalsMode == false);
	EnableWindow("accounteditbox", not submit and fullHS);
	EnableWindow("passeditbox", not submit and fullHS);
	EnableWindow("remember", not submit and fullHS);

	EnableWindow("submittoserver", not submit);
	EnableWindow("submitcancel", not submit);
	EnableWindow("submitconnect", submit);

end



MakeDialog
{
	name="hiscoresubmitscreen",
	Bitmap
	{ 
		image="backgrounds/dialog",	
		x=kCenter,
		y=kCenter,

		SetStyle(DefaultStyle);
		Text
		{
			font = HeaderFont,
			name = "header",
			x=0,y=22,w=kMax,h=kMax,
			flags = kHAlignCenter + kVAlignTop,
			label = "submitglobal"
		};
		
		Text
		{
			font = AccountFont,
			name = "playertext",
			x=0,y=kPlayerNameY,w=145,h=kMax,
			flags = kHAlignRight + kVAlignTop,
			label = "playerlabel"
		};
		
		Text
		{
			font = AccountFont,
			name = "yourscore",
			x=0,y=kScoreY,w=142,h=kMax,
			flags = kHAlignRight + kVAlignTop,
			label = "scorelabel"
		};
		
		Text
		{
			font = AccountFont,
			name = "eligiblescore",
			x=205,y=kScoreY,w=100,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			label = gEligibleScore
		};
		
		Text
		{
			font = ScoreFont,
			name = "yourpfaccount",
			x=145,y=kYourPFAccountY,w=150,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			label = "yourpfaccount"
		};
		
		Text
		{
			font = AccountFont,
			name = "nametext",
			x=0,y=kAccountNameY,w=145,h=kMax,
			flags = kHAlignRight + kVAlignTop,
			label = "namelabel"
		};
		
		Text
		{
			font = AccountFont,
			name = "passtext",
			x=0,y=kPasswordY,w=145,h=kMax,
			flags = kHAlignRight + kVAlignTop,
			label = "passwordlabel"
		};
		
		Text
		{
			font = TableInfoFont,
			name = "submitconnect",
			x=0,y=0,w=kMax,h=kMax,
			flags = kHAlignCenter + kVAlignCenter,
			label = "connectingtoserver"
		};
		
		Text
		{
			font = ErrorFont,
			name = "submiterror",
			x=40,y=0,w=kMax-60,h=kMax,
			flags = kHAlignCenter + kVAlignCenter,
			label = "Error Message"
		};
		
		Text
		{
			x = 40, w = kMax-40,
			y = 265, h = kMax,
			font = HiscoreSubmitLegal;
			flags = kHAlignLeft + kVAlignTop,
			label = kPrivacyLabel
		};

		Bitmap
		{
			name="nameeditbox",
			image="backgrounds/textfield2.png",
			x=155,
			y=kPlayerNameY,
			
			TextEdit
			{
				font = AccountFont2,
				name = "nameedit",
				label = gNameEdit,
				x=0,y=3,w=kMax,h=kMax,
				length=20,
				ignore = kIllegalNameChars
				
			};
		};
		
		Bitmap
		{
			name="accounteditbox",
			image="backgrounds/textfield2.png",
			x=155,
			y=kAccountNameY,
			
			TextEdit
			{
				font = AccountFont2,
				name = "accountedit",
				label= gAccountEdit,
				x=0,y=3,w=kMax,h=kMax,
				length=26,
				ignore = kIllegalNameChars
				
			};
		};
		
		Bitmap
		{
			name="passeditbox",
			image="backgrounds/textfield2.png",
			x=155,
			y=kPasswordY,
			
			TextEdit
			{
				font = AccountFont2,
				name = "passedit",
				label= gPassEdit,
				x=0,y=3,w=kMax,h=kMax,
				password = true,
				length=26
				
			};
		};
		
		SetStyle( CheckboxButtonStyle ),
		Button
		{
			x=55, y=kRememberY,

			name="remember",
			type = kToggle,
			w=290,
			scale=0.5,
			rollover = "",
			drop = false,
			sound = "audio/sfx/checkbox.ogg",
			Text
			{
				font = AccountFont,
				name = "rememberlabel",
				x=40,
				y=0,
				w=290,
				h=25,
				flags = kHAlignLeft + kVAlignTop,
				label="rememberpfaccount",
			};
		};
		
		SetStyle( ButtonStyle ),
		Button
		{
			x=130, y=kMax-30,

			name="submittoserver",
			label="submit",
			graphics= vHSButtonGraphics,
			font	= vHSButtonFontStyle,
			type = kPush,
			default= true, -- this should be the default button (on enter)

			command = 
				function()
					name = GetLabel("nameedit");
					account = GetLabel("accountedit");
					pass = GetLabel("passedit");
					remember = GetButtonToggleState("remember");
					SubmitToServer(name,account,pass,remember,gMedalsMode);
				end
		},
		
		
		Button
		{
			x=267, y=kMax-30,

			name="submitcancel",
			label="cancel",
			graphics= vHSButtonGraphics,
			font	= vHSButtonFontStyle,
			type = kPush,
			command = 
				function()
					PopModal("hiscoresubmitscreen"); -- take off high score menu, restart game loop
				end
		};
		
		Button
		{
			x=150, y=kMax-30,

			name="submiterrorok",
			label="ok",
			graphics= vHSButtonGraphics,
			font	= vHSButtonFontStyle,
			type = kPush,
			command=
				function()
					EnableWindow("submiterrorok",false);
					EnableWindow("submiterror",false);
					SwitchModes(false);
				end
		};
		
		MenuButton
		{
			x=150+30, y=kMax-67,
			w=100,
			name="privacy_link",
			LinkLabel("privacy_policy"),
			type = kPush,
			command = 
				function()
					if (IsEnabled(kHiscoreAnonymous)) then
						DisplayDialog { 
							"scripts/ok.lua", 
							body ="privacy_anon",
							title = ""
						};
					else
						LaunchPrivacyPolicy();
					end
				end
		},
		
		-- no used !!
		Button
		{
			x=0,
			y=0,
			w=0,
			h=0,
			graphics={},
			name="privacybutton",
			command = 
				function()
					if (IsEnabled(kHiscoreAnonymous)) then
						DisplayDialog { 
							"scripts/ok.lua", 
							body ="privacy_anon",
							title = ""
						};
					else
						LaunchPrivacyPolicy();
					end
				end
		};
	}
}

EnableWindow("submitconnect", false);
EnableWindow("submiterror",false);
EnableWindow("submiterrorok", false);

if gMedalsMode then
	SwitchModes(false);
end

if (gMedalsMode) then
	SetFocus("accountedit");
else
	SetButtonToggleState('remember',gRemember);
	SetFocus("nameedit");
end